import pickle
from helper.tags_helper import remove_stop_words


clymb_resource_list_model = pickle.load(open('clymb_resource_list.pkl', 'rb'))
clymb_resource_similarity = pickle.load(open('clymb_resource_similarity.pkl', 'rb'))


def recommend_top_three(categories, texts):

    df_categories = clymb_resource_list_model[clymb_resource_list_model['categories'].apply(lambda x: any([i in x for i in categories.split(",")]))]
    
    # Initialize an empty dictionary
    id_count = {}
    texts = remove_stop_words(texts.replace('|', ' ').lower()).split()
    print(texts)
    for text in texts:
        dataframe = df_categories[df_categories['tags'].str.contains(text)]
        if not dataframe.empty:
            for index in dataframe.index:
                distances = sorted(list(enumerate(clymb_resource_similarity[index])),reverse=True,key = lambda x: x[1])
                for i in distances[0:3]:
                    id = clymb_resource_list_model.iloc[i[0]].post_id.astype('int64')
                    if id in id_count:
                        id_count[id] += 1
                    else:
                        id_count[id] = 1
    
    sorted_dict = dict(sorted(id_count.items(), key=lambda item: item[1], reverse=True))
    # print(sorted_dict)
    
    top_3_post = list(sorted_dict.keys())[:3]
    # print(top_3_post)
     
    # print(df_categories.shape)
    
    # for index, row in df_categories.iterrows():
    #     print(f"{row['post_id']} {row['categories']}")
        
    top_3_post_df = clymb_resource_list_model[clymb_resource_list_model['post_id'].isin(top_3_post)]
    return top_3_post_df.to_dict('records');