import requests

def get_categories(texts): 

    url = 'https://ifs.evdpl.com/api/compass-dashboard/get-low-score-categories-by-assessment-texts'

    inputs = texts.split('|')

    # Define the request body with four parameters
    data = {
        "self_awareness": inputs[0],
        "responsible_decision_making": inputs[1],
        "self_management": inputs[2],
        "social_awareness": inputs[3],
        "relationship_skills": ",".join(inputs[4:])
    }

    print(f"RequestBody: {data}")

    # Make the POST request
    response = requests.post(url, json=data)

    # Check the response status code
    if response.status_code == 200:
        categories = []
        # Parse the JSON response
        for item in response.json():
            response_data = item['category']['category_name']
            categories.append(response_data)
        
        return ",".join(categories[0:3])
    else:
        raise Exception(response.text)

try:
    lowest_categories = get_categories("Angry| I'm learning|Somewhat Motivated|I am comfortable with making new friends who are different from me.|Does not communicate|Trying to work together|Thinking about asking for help|Ignores negative peer pressure")
    print(lowest_categories)
except Exception as err:
    print(f"Error {err}")